/*
 * ADOBE CONFIDENTIAL
 *
 * Copyright (c) 2015 Adobe Systems Incorporated. All rights reserved.
 *
 * NOTICE:  All information contained herein is, and remains
 * the property of Adobe Systems Incorporated and its suppliers,
 * if any.  The intellectual and technical concepts contained
 * herein are proprietary to Adobe Systems Incorporated and its
 * suppliers and are protected by trade secret or copyright law.
 * Dissemination of this information or reproduction of this material
 * is strictly forbidden unless prior written permission is obtained
 * from Adobe Systems Incorporated.
 */

/*jslint vars: true, plusplus: true, devel: true, nomen: true, indent: 4, bitwise: true, node: true, expr: true */
/*global define, require, _, $, module, describe, it, expect, afterEach, beforeEach */

"use strict";

var sinon = require("sinon"),
    MaxPixels = require("../MaxPixels");

describe("MaxPixels", function(){
    var sandbox = sinon.sandbox.create();

    beforeEach(function () {
        sandbox.stub(MaxPixels, "getMaxPixels").returns(1 * 1000 * 1000);
    });

    afterEach(function () {
        sandbox.restore();
    });

    it("computes a max scale factor less than one", function () {
        expect(MaxPixels.getMaxScaleFactor({ width: 2000, height: 1000 })).to.equal(0.70);
    });

    it("computes a max scale factor greater than one", function () {
        // sqrt(1000000 / (2000 * 1000)) = 2.236, rounded down to 2.23
        expect(MaxPixels.getMaxScaleFactor({ width: 400, height: 500 })).to.equal(2.23);
    });

    it("accepts a specific max pixels value when computing the max scale factor", function () {
        expect(MaxPixels.getMaxScaleFactor({ width: 20, height: 20 }, 100)).to.equal(0.5);
    });

    it("computes max dimensions less than the original dimensions", function () {
        expect(MaxPixels.getMaxDimensions({ width: 2000, height: 1000 })).to.eql({ width: 1400, height: 700 });
    });

    it("computes max dimensions greater than the original dimensions", function () {
        // maxScaleFactor = sqrt(1000000 / (2000 * 1000)) = 2.236, rounded down to 2.23
        // 400 * 2.23 x 500 * 2.23 = 892 x 1115
        expect(MaxPixels.getMaxDimensions({ width: 400, height: 500 })).to.eql({ width: 892, height: 1115 });
    });
});
